/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.common.casting.arithmetic;

import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.arithmetic.engine.InvalidOperatorException;
import at.petrak.hexcasting.api.casting.arithmetic.operator.Operator;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorBinary;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorUnary;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaMultiPredicate;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaPredicate;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;
import org.jetbrains.annotations.NotNull;
import ram.talia.moreiotas.api.OperatorUtilsKt;
import ram.talia.moreiotas.api.casting.iota.MatrixIota;
import ram.talia.moreiotas.common.casting.arithmetic.operator.matrix.OperatorMatrixAdd;
import ram.talia.moreiotas.common.casting.arithmetic.operator.matrix.OperatorMatrixDiv;
import ram.talia.moreiotas.common.casting.arithmetic.operator.matrix.OperatorMatrixMul;
import ram.talia.moreiotas.common.casting.arithmetic.operator.matrix.OperatorMatrixPow;
import ram.talia.moreiotas.common.lib.hex.MoreIotasIotaTypes;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0012\u001a\u00020\r2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0016\u001a\u00020\u00152\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001cR\"\u0010\"\u001a\u0010\u0012\f\u0012\n !*\u0004\u0018\u00010\u00050\u00050 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lram/talia/moreiotas/common/casting/arithmetic/MatrixArithmetic;", "Lat/petrak/hexcasting/api/casting/arithmetic/Arithmetic;", "", "arithName", "()Ljava/lang/String;", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "pattern", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/Operator;", "getOperator", "(Lat/petrak/hexcasting/api/casting/math/HexPattern;)Lat/petrak/hexcasting/api/casting/arithmetic/operator/Operator;", "Ljava/util/function/UnaryOperator;", "Lorg/jblas/DoubleMatrix;", "op", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorUnary;", "make1", "(Ljava/util/function/UnaryOperator;)Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorUnary;", "Ljava/util/function/Function;", "", "make1Double", "(Ljava/util/function/Function;)Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorUnary;", "Ljava/util/function/BinaryOperator;", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorBinary;", "make2SameSize", "(Ljava/util/function/BinaryOperator;)Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorBinary;", "", "opTypes", "()Ljava/lang/Iterable;", "ALTADD", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "ALTDIV", "ALTMUL", "ALTPOW", "", "kotlin.jvm.PlatformType", "OPS", "Ljava/util/List;", "<init>", "()V", "moreiotas-fabric-1.20.1"})
public final class MatrixArithmetic
implements Arithmetic {
    @NotNull
    public static final MatrixArithmetic INSTANCE = new MatrixArithmetic();
    @JvmField
    @NotNull
    public static final HexPattern ALTADD = HexPattern.Companion.fromAngles("waawawaeawwaea", HexDir.EAST);
    @JvmField
    @NotNull
    public static final HexPattern ALTMUL = HexPattern.Companion.fromAngles("waqawawwaeaww", HexDir.SOUTH_EAST);
    @JvmField
    @NotNull
    public static final HexPattern ALTDIV = HexPattern.Companion.fromAngles("wdedwdwwdqdww", HexDir.NORTH_EAST);
    @JvmField
    @NotNull
    public static final HexPattern ALTPOW = HexPattern.Companion.fromAngles("wedewqawwawqwa", HexDir.NORTH_EAST);
    @NotNull
    private static final List<HexPattern> OPS;

    private MatrixArithmetic() {
    }

    @NotNull
    public String arithName() {
        return "matrix_maths";
    }

    @NotNull
    public Iterable<HexPattern> opTypes() {
        return OPS;
    }

    @NotNull
    public Operator getOperator(@NotNull HexPattern pattern) {
        Operator operator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        HexPattern hexPattern = pattern;
        if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ADD)) {
            operator = (Operator)new OperatorMatrixAdd(false);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.SUB)) {
            operator = (Operator)new OperatorMatrixAdd(true);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.MUL)) {
            operator = (Operator)OperatorMatrixMul.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)ALTMUL)) {
            operator = (Operator)this.make2SameSize(MatrixArithmetic::getOperator$lambda$0);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.DIV)) {
            operator = (Operator)OperatorMatrixDiv.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)ALTDIV)) {
            operator = (Operator)this.make2SameSize(MatrixArithmetic::getOperator$lambda$1);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ABS)) {
            operator = (Operator)this.make1Double(MatrixArithmetic::getOperator$lambda$2);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.POW)) {
            operator = (Operator)OperatorMatrixPow.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)ALTPOW)) {
            operator = (Operator)this.make2SameSize(MatrixArithmetic::getOperator$lambda$3);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.FLOOR)) {
            operator = (Operator)this.make1(MatrixFunctions::floor);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.CEIL)) {
            operator = (Operator)this.make1(MatrixFunctions::ceil);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.REV)) {
            operator = (Operator)this.make1(DoubleMatrix::transpose);
        } else {
            throw new InvalidOperatorException(pattern + " is not a valid operator in Arithmetic " + this + ".");
        }
        return operator;
    }

    private final OperatorUnary make1Double(Function<DoubleMatrix, Double> op) {
        return new OperatorUnary(IotaMultiPredicate.all((IotaPredicate)IotaPredicate.ofType(MoreIotasIotaTypes.MATRIX)), arg_0 -> MatrixArithmetic.make1Double$lambda$4(op, arg_0));
    }

    private final OperatorUnary make1(UnaryOperator<DoubleMatrix> op) {
        return new OperatorUnary(IotaMultiPredicate.all((IotaPredicate)IotaPredicate.ofType(MoreIotasIotaTypes.MATRIX)), arg_0 -> MatrixArithmetic.make1$lambda$5(op, arg_0));
    }

    private final OperatorBinary make2SameSize(BinaryOperator<DoubleMatrix> op) {
        return new OperatorBinary(IotaMultiPredicate.all((IotaPredicate)IotaPredicate.ofType(MoreIotasIotaTypes.MATRIX)), (arg_0, arg_1) -> MatrixArithmetic.make2SameSize$lambda$6(op, arg_0, arg_1));
    }

    private static final DoubleMatrix getOperator$lambda$0(DoubleMatrix i, DoubleMatrix j) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Intrinsics.checkNotNullParameter((Object)j, (String)"j");
        return i.mul(j);
    }

    private static final DoubleMatrix getOperator$lambda$1(DoubleMatrix i, DoubleMatrix j) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Intrinsics.checkNotNullParameter((Object)j, (String)"j");
        return i.div(j);
    }

    private static final Double getOperator$lambda$2(DoubleMatrix it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.norm2();
    }

    private static final DoubleMatrix getOperator$lambda$3(DoubleMatrix i, DoubleMatrix j) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Intrinsics.checkNotNullParameter((Object)j, (String)"j");
        return MatrixFunctions.pow((DoubleMatrix)i, (DoubleMatrix)j);
    }

    private static final Iota make1Double$lambda$4(Function $op, Iota i) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Object r = $op.apply(((MatrixIota)Operator.Companion.downcast(i, MoreIotasIotaTypes.MATRIX)).getMatrix());
        Intrinsics.checkNotNullExpressionValue(r, (String)"op.apply(Operator.downcast(i, MATRIX).matrix)");
        return (Iota)new DoubleIota(((Number)r).doubleValue());
    }

    private static final Iota make1$lambda$5(UnaryOperator $op, Iota i) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        return new MatrixIota((DoubleMatrix)$op.apply(((MatrixIota)Operator.Companion.downcast(i, MoreIotasIotaTypes.MATRIX)).getMatrix()));
    }

    private static final Iota make2SameSize$lambda$6(BinaryOperator $op, Iota i, Iota j) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullExpressionValue((Object)i, (String)"i");
        DoubleMatrix mat0 = ((MatrixIota)Operator.Companion.downcast(i, MoreIotasIotaTypes.MATRIX)).getMatrix();
        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"j");
        DoubleMatrix mat1 = ((MatrixIota)Operator.Companion.downcast(j, MoreIotasIotaTypes.MATRIX)).getMatrix();
        if (mat0.rows != mat1.rows || mat0.columns != mat1.columns) {
            throw OperatorUtilsKt.matrixWrongSize(MishapInvalidIota.Companion, new MatrixIota(mat1), 0, mat0.rows, mat1.columns);
        }
        return new MatrixIota((DoubleMatrix)$op.apply(mat0, mat1));
    }

    static {
        Object[] objectArray = new HexPattern[]{Arithmetic.ADD, Arithmetic.SUB, Arithmetic.MUL, ALTMUL, Arithmetic.DIV, ALTDIV, Arithmetic.ABS, Arithmetic.POW, ALTPOW, Arithmetic.FLOOR, Arithmetic.CEIL, Arithmetic.REV};
        OPS = CollectionsKt.listOf((Object[])objectArray);
    }
}

